
##--------------------------------------------------------------------------------------------------------------------------------------##

                                ## Set working directory, define data, run models, AIC ##

##--------------------------------------------------------------------------------------------------------------------------------------##

# Set working directory
setwd("E:/Ilona")

# Install packages to be used
      
install.packages("lme4")
install.packages("optimx")
install.packages("MuMIn")
install.packages("knitr")
install.packages("AICcmodavg")

# Load packages used for models, AIC, and plots
library(lme4)
library(optimx)
library(MuMIn) 
library(knitr)
library(AICcmodavg)

# Read data file
newdata <- read.csv("Mihalikdata.csv")

# Remove NA values
newdata2 <- (newdata[complete.cases(newdata), ])

# Rescale continuous data#
newdata2$mass.s = (newdata2$Avg.Mass - mean(newdata2$Avg.Mass))/sd(newdata2$Avg.Mass)
newdata2$status.s = (newdata2$Status - mean(newdata2$Status))/sd(newdata2$Status)
newdata2$lat.s = (newdata2$Latitude - mean(newdata2$Latitude))/sd(newdata2$Latitude)


# Run glmer models (m1 - m15) for predictors against response (price) based off our hypotheses

m1 <- glmer(Day.price ~ 
               status.s
             + Classification
             + SCI
             + SCI:mass.s
             + mass.s
             + mass.s:Classification
             + (1|Species) + (1|Province.State), 
             data = newdata2, 
             family = Gamma(link='log'),
             control = glmerControl(optimizer = "optimx", calc.derivs = TRUE, optCtrl = list(method = "nlminb", starttests = FALSE, kkt = FALSE)))


m2 <- glmer(Day.price ~
               mass.s
             + (1|Species) + (1|Province.State), 
             data = newdata2, 
             family = Gamma(link='log'))


m3 <- glmer(Day.price ~ 
               Classification
             + mass.s         
             + Classification:mass.s
             + (1|Species) + (1|Province.State), 
             data = newdata2, 
             family = Gamma(link='log'))


m4 <- glmer(Day.price ~ 
               SCI
             + mass.s            
             + (1|Species) + (1|Province.State), 
             data = newdata2, 
             family = Gamma(link='log'))


m5 <- glmer(Day.price ~ 
               SCI 
             + mass.s   
             + SCI:mass.s
             + (1|Species) + (1|Province.State), 
             data = newdata2, 
             family = Gamma(link='log'))


m6 <- glmer(Day.price ~ 
               status.s
             + mass.s
             + (1|Species) + (1|Province.State), 
             data = newdata2, 
             family = Gamma(link='log'))


m7 <- glmer(Day.price ~ 
                Classification
              + mass.s
              + SCI   
              + Classification:mass.s
              + (1|Species) + (1|Province.State), 
              data = newdata2, 
              family = Gamma(link='log'))


m8 <- glmer(Day.price ~ 
                Classification
              + mass.s
              + SCI   
              + SCI:mass.s
              + Classification:mass.s
              + (1|Species) + (1|Province.State), 
              data = newdata2, 
              family = Gamma(link='log'),
              control = glmerControl(optimizer = "optimx", calc.derivs = TRUE, optCtrl = list(method = "nlminb", starttests = FALSE, kkt = FALSE)))


m9 <- glmer(Day.price ~ 
                Classification
              + mass.s 
              + status.s
              + Classification:mass.s
              + (1|Species) + (1|Province.State), 
              data = newdata2, 
              family = Gamma(link='log'))


m10 <- glmer(Day.price ~ 
                SCI 
              + mass.s   
              + status.s
              + (1|Species) + (1|Province.State), 
              data = newdata2, 
              family = Gamma(link='log'),
              control = glmerControl(optimizer = "optimx", calc.derivs = TRUE, optCtrl = list(method = "nlminb", starttests = FALSE, kkt = FALSE)))


m11 <- glmer(Day.price ~ 
                SCI 
              + mass.s 
              + status.s
              + SCI:mass.s
              + (1|Species) + (1|Province.State), 
              data = newdata2, 
              family = Gamma(link='log'))


m12 <- glmer(Day.price ~ 
                SCI
              + (1|Species) + (1|Province.State), 
              data = newdata2, 
              family = Gamma(link='log'))


m13 <- glmer(Day.price ~ 
                SCI
              + status.s
              + (1|Species) + (1|Province.State), 
              data = newdata2, 
              family = Gamma(link='log'),
              control=glmerControl(optimizer="bobyqa", optCtrl=list(maxfun=100000)))


m14 <- glmer(Day.price ~ 
                status.s
              + (1|Species) + (1|Province.State), 
              data = newdata2, 
              family = Gamma(link='log'))


m15 <-glmer(Day.price ~ 1  
             + (1|Species) + (1|Province.State), 
             data = newdata2, 
             family = Gamma(link='log'))

# Check model summaries
summary(m1) # global
summary(m2) # ~ mass
summary(m3) # ~ class + mass + class:mass
summary(m4) # ~ SCI + mass
summary(m5) # ~ SCI + mass + SCI:mass
summary(m6) # ~ status + mass
summary(m7) # ~ class + mass + SCI + class:mass
summary(m8) # ~ class + mass + SCI + SCI:mass + class:mass
summary(m9) # ~ class + mass + status + class:mass
summary(m10) # ~ SCI + mass + status
summary(m11) # ~ SCI + mass + status + SCI:mass
summary(m12) # ~ SCI
summary(m13) # ~ SCI + status
summary(m14) # ~ status
summary(m15) # null

# AIC
AIC(m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15)

# Model selection table with AIC 
model_tableb <- model.sel(m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, rank = AIC)
model_tableb$cum.weight = cumsum(model_tableb$weight)
kable(model_tableb, digits = 3)


##--------------------------------------------------------------------------------------------------------------------------------------##

                                          ## Figures - Figure 1; S1a,b; S2a,b; S3a,b; S4; S5 ##

##--------------------------------------------------------------------------------------------------------------------------------------##


## Figure 1 - in text. Top model ##

masses = seq(-1.5,2,0.1)
min(which(newdata2$Classification=="Ungulate"))
min(which(newdata2$Classification=="Carnivore"))

# For carnivore predictions
dat.car = newdata2[rep(min(which(newdata2$Classification=="Carnivore")),
                       times=length(masses)),]

dat.car$mass.s = masses
dat.car$status.s = mean(newdata2$status.s)
dat.car$SCI = unique(newdata2$SCI)[1]

pred.car = modavgPred(cand.set=list(m3),
                      newdata=dat.car, 
                      second.ord = TRUE,
                      nobs = NULL, 
                      uncond.se = "revised", 
                      conf.level = 0.95)

dat.car$pred = pred.car$mod.avg.pred
dat.car$LCI = pred.car$lower.CL
dat.car$UCI = pred.car$upper.CL

# For ungulate predictions
dat.un = newdata2[rep(min(which(newdata2$Classification=="Ungulate")),
                      times=length(masses)),]

dat.un$mass.s = masses
dat.un$status.s = mean(newdata2$status.s)
dat.un$SCI = unique(newdata2$SCI)[1]

pred.un = modavgPred(cand.set=list(m3), 
                     newdata=dat.un, 
                     second.ord = TRUE,
                     nobs = NULL, 
                     uncond.se = "revised", 
                     conf.level = 0.95)

dat.un$pred = pred.un$mod.avg.pred
dat.un$LCI = pred.un$lower.CL
dat.un$UCI = pred.un$upper.CL

# Plot Figure 1

back.trans = function(x){
  x*sd(newdata2$Avg.Mass)+mean(newdata2$Avg.Mass)
}

plot(as.numeric(back.trans(newdata2$mass.s[newdata2$Classification=='Carnivore'])),
     newdata2$Day.price[newdata2$Classification=='Carnivore'], 
     col='#FF8C0055',
     pch=17, 
     xlab = "Average mass (kg)", 
     ylab = "Price per day (USD)")

points(as.numeric(back.trans(newdata2$mass.s[newdata2$Classification=='Ungulate'])),
       newdata2$Day.price[newdata2$Classification=='Ungulate'], 
       col='#19197055',
       pch=16)

lines(back.trans(dat.car$mass.s),
      dat.car$pred, 
      col='#FF8C00', 
      lwd = 1.5)

polygon(c(back.trans(dat.car$mass.s),
          rev(back.trans(dat.car$mass.s))),
        c(dat.car$LCI,
          rev(dat.car$UCI)),
        col='#FFDE0055', 
        border=NA)

lines(back.trans(dat.un$mass.s),
      dat.un$pred, 
      col='#191970', 
      lwd = 1.5)

polygon(c(back.trans(dat.un$mass.s),
          rev(back.trans(dat.un$mass.s))),
        c(dat.un$LCI,
          rev(dat.un$UCI)),
        col='#19197055', 
        border=NA)

legend(125,
       4650, 
       legend=c("Carnivore", "Ungulate"),
       col=c("#FF8C00", "#191970"), 
       pch = c(17,16), 
       bty = "n",
       cex=0.80)



## Figure S1 - in Supplementary Material. (a) Model-averaged and (b) global model predictions for the effect of mass on price for carnivore and ungulate species. ##

## Figure S1a - Model-averaged

masses = seq(-1.5,2,0.1)
min(which(newdata2$Classification=="Ungulate"))
min(which(newdata2$Classification=="Carnivore"))

# For carnivore predictions

dat.car = newdata2[rep(min(which(newdata2$Classification=="Carnivore")),
                       times=length(masses)),]

dat.car$mass.s = masses
dat.car$status.s = mean(newdata2$status.s)
dat.car$SCI = unique(newdata2$SCI)[1] # Both carnivore and ungulate predictions include 'average' predictions for presence and absence of SCI difficult/dangerous comments. First running with SCI as [1] 'presence'. 


pred.car = modavgPred(cand.set=list(m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15), 
                      newdata=dat.car, 
                      second.ord = TRUE,
                      nobs = NULL, 
                      uncond.se = "revised", 
                      conf.level = 0.95)

pred.car1 = pred.car$mod.avg.pred
pred.car1.LCI = pred.car$lower.CL
pred.car1.UCI = pred.car$upper.CL

dat.car$SCI = unique(newdata2$SCI)[2] # Now with SCI as [2] 'absence'

pred.car = modavgPred(cand.set=list(m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15), 
                      newdata=dat.car, 
                      second.ord = TRUE,
                      nobs = NULL, 
                      uncond.se = "revised", 
                      conf.level = 0.95)

pred.car2 = pred.car$mod.avg.pred
pred.car2.LCI = pred.car$lower.CL
pred.car2.UCI = pred.car$upper.CL

# To get carnivore predictions with 'average' SCI 

dat.car$pred = (pred.car1 + pred.car2)/2
dat.car$LCI = (pred.car1.LCI + pred.car2.LCI)/2
dat.car$UCI = (pred.car1.UCI + pred.car2.UCI)/2

# For ungulate predictions

dat.un = newdata2[rep(min(which(newdata2$Classification=="Ungulate")),
                      times=length(masses)),]

dat.un$mass.s = masses
dat.un$status.s = mean(newdata2$status.s)
dat.un$SCI = unique(newdata2$SCI)[1] # First with SCI as [1] 'presence'

pred.un = modavgPred(cand.set=list(m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15), 
                     newdata=dat.un, 
                     second.ord = TRUE,
                     nobs = NULL, 
                     uncond.se = "revised", 
                     conf.level = 0.95)

pred.un1 = pred.un$mod.avg.pred
pred.un1.LCI = pred.un$lower.CL
pred.un1.UCI = pred.un$upper.CL


dat.un$SCI = unique(newdata2$SCI)[2] # Now with SCI as [2] 'absence'

pred.un = modavgPred(cand.set=list(m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15), 
                     newdata=dat.un, 
                     second.ord = TRUE,
                     nobs = NULL, 
                     uncond.se = "revised", 
                     conf.level = 0.95)

pred.un2 = pred.un$mod.avg.pred
pred.un2.LCI = pred.un$lower.CL
pred.un2.UCI = pred.un$upper.CL

# To get ungulate predictions with 'average' SCI

dat.un$pred = (pred.un1 + pred.un2)/2
dat.un$LCI = (pred.un1.LCI + pred.un2.LCI)/2
dat.un$UCI = (pred.un1.UCI + pred.un2.UCI)/2


# Plot Figure S1a
par(mfrow=c(1,2))

back.trans = function(x){
  x*sd(newdata2$Avg.Mass)+mean(newdata2$Avg.Mass)
}

plot(back.trans(as.numeric(newdata2$mass.s[newdata2$Classification=='Carnivore'])),
     newdata2$Day.price[newdata2$Classification=='Carnivore'], 
     col='#FF8C0055',
     pch=17, 
     xlab = "Average mass (kg)", 
     ylab = "Price per day (USD)", 
     xlim=c(25, 417))

points(back.trans(as.numeric(newdata2$mass.s[newdata2$Classification=='Ungulate'])),
       newdata2$Day.price[newdata2$Classification=='Ungulate'], 
       col='#19197055',
       pch=16)

lines(back.trans(dat.car$mass.s),
      dat.car$pred, 
      col='ORANGE', 
      lwd = 1.5)

polygon(c(back.trans(dat.car$mass.s),
          rev(back.trans(dat.car$mass.s))),
        c(dat.car$LCI,
          rev(dat.car$UCI)),
        col='#FFDE0055', 
        border=NA)

lines(back.trans(dat.un$mass.s),
      dat.un$pred, 
      col='MIDNIGHTBLUE', 
      lwd = 1.5)

polygon(c(back.trans(dat.un$mass.s),
          rev(back.trans(dat.un$mass.s))),
        c(dat.un$LCI,
          rev(dat.un$UCI)),
        col='#19197055', 
        border=NA)


## S1b - Global model 

masses = seq(-1.5,2,0.1)
min(which(newdata2$Classification=="Ungulate"))
min(which(newdata2$Classification=="Carnivore"))

# For carnivore predictions

dat.car = newdata2[rep(min(which(newdata2$Classification=="Carnivore")),
                       times=length(masses)),]

dat.car$mass.s = masses
dat.car$status.s = mean(newdata2$status.s)
dat.car$SCI = unique(newdata2$SCI)[1] # First running with SCI as [1] 'presence'


pred.car = modavgPred(cand.set=list(m1), 
                      newdata=dat.car, second.ord = TRUE,
                      nobs = NULL, 
                      uncond.se = "revised", 
                      conf.level = 0.95)

pred.car1 = pred.car$mod.avg.pred
pred.car1.LCI = pred.car$lower.CL
pred.car1.UCI = pred.car$upper.CL

dat.car$SCI = unique(newdata2$SCI)[2] # Then changing SCI to [2] 'absence'

pred.car = modavgPred(cand.set=list(m1), 
                      newdata=dat.car, 
                      second.ord = TRUE,
                      nobs = NULL, 
                      uncond.se = "revised", 
                      conf.level = 0.95)

pred.car2 = pred.car$mod.avg.pred
pred.car2.LCI = pred.car$lower.CL
pred.car2.UCI = pred.car$upper.CL

# To get carnivore predictions with 'average' SCI

dat.car$pred = (pred.car1 + pred.car2)/2
dat.car$LCI = (pred.car1.LCI + pred.car2.LCI)/2
dat.car$UCI = (pred.car1.UCI + pred.car2.UCI)/2

# Ungulate predictions

dat.un = newdata2[rep(min(which(newdata2$Classification=="Ungulate")),
                      times=length(masses)),]

dat.un$mass.s = masses
dat.un$status.s = mean(newdata2$status.s)
dat.un$SCI = unique(newdata2$SCI)[1] # First running with SCI as [1] 'presence'

pred.un = modavgPred(cand.set=list(m1),
                     newdata=dat.un, 
                     second.ord = TRUE,
                     nobs = NULL, 
                     uncond.se = "revised", 
                     conf.level = 0.95)

pred.un1 = pred.un$mod.avg.pred
pred.un1.LCI = pred.un$lower.CL
pred.un1.UCI = pred.un$upper.CL


# Finally run these with SCI as [2]

dat.un$SCI = unique(newdata2$SCI)[2] # Then running with SCI as [2] 'absence'

pred.un = modavgPred(cand.set=list(m1),
                     newdata=dat.un, 
                     second.ord = TRUE,
                     nobs = NULL, 
                     uncond.se = "revised", 
                     conf.level = 0.95)

pred.un2 = pred.un$mod.avg.pred
pred.un2.LCI = pred.un$lower.CL
pred.un2.UCI = pred.un$upper.CL

# To get ungulate predictions with 'average' SCI

dat.un$pred = (pred.un1 + pred.un2)/2
dat.un$LCI = (pred.un1.LCI + pred.un2.LCI)/2
dat.un$UCI = (pred.un1.UCI + pred.un2.UCI)/2


# Plot Figure S1b

back.trans = function(x){
  x*sd(newdata2$Avg.Mass)+mean(newdata2$Avg.Mass)
}

plot(back.trans(as.numeric(newdata2$mass.s[newdata2$Classification=='Carnivore'])),
     newdata2$Day.price[newdata2$Classification=='Carnivore'], 
     col='#FF8C0055',
     pch=17, 
     xlab = "Average mass (kg)", 
     ylab = "Price per day (USD)", 
     xlim=c(25, 417))

points(back.trans(as.numeric(newdata2$mass.s[newdata2$Classification=='Ungulate'])),
       newdata2$Day.price[newdata2$Classification=='Ungulate'], 
       col='#19197055',
       pch=16)

lines(back.trans(dat.car$mass.s),
      dat.car$pred, 
      col='ORANGE', 
      lwd = 1.5)

polygon(c(back.trans(dat.car$mass.s),
          rev(back.trans(dat.car$mass.s))),
        c(dat.car$LCI,
          rev(dat.car$UCI)),
        col='#FFDE0055', 
        border=NA)

lines(back.trans(dat.un$mass.s),
      dat.un$pred, 
      col='MIDNIGHTBLUE', 
      lwd = 1.5)

polygon(c(back.trans(dat.un$mass.s),
          rev(back.trans(dat.un$mass.s))),
        c(dat.un$LCI,
          rev(dat.un$UCI)),
        col='#19197055', 
        border=NA)

legend(x = c(250, 375), 
       y = c(5000, 4300), 
       legend=c("Carnivore", "Ungulate"),
       col=c("#FF8C00", "#191970"), 
       pch = c(17,16),
       bty = "n",
       cex=0.70)



## Figure S2 - in Supplementary Material. (a) Model-averaged and (b) global model predictions for the effect of presence/absence of difficult and/or dangerous description by SCI. ##

## Figure S2a - Model-averaged predictions

d = newdata2[c(1:4),]
d$Classification = unique(newdata2$Classification)[c(1,1,2,2)]
d$status.s = mean(newdata2$status.s)
d$mass.s = mean(newdata2$mass.s)
d$SCI = unique(newdata2$SCI)[c(1,2,1,2)]  

carpred.coef = modavgPred(cand.set=list(m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15), 
                          newdata=d, 
                          re.form=~0, 
                          conf.level = 0.95)

d$pred = carpred.coef$mod.avg.pred
d$LCI = carpred.coef$lower.CL
d$UCI = carpred.coef$upper.CL

# Plot Figure S2a
par(mfrow=c(1,2))

plot(c(1,2)-0.125, 
     d$pred[c(1,2)], 
     xlim=c(0.5,2.5), 
     pch = 16, 
     col = "#FF8C00", 
     ylim=c(0,1600), 
     ylab = "Price per day (USD)",
     xlab = "Difficult or dangerous",
     axes=FALSE)

box(); axis(2); axis(1, at=c(1,2),
                     labels=c('Yes','No'))

points(c(1,2)+0.125,
       d$pred[c(3,4)],
       pch = 16,
       col = "#191970")

lines(c(1,1)-0.125,
      d[1,c("LCI", "UCI")],
      lty = 1,
      col = "#FF8C00")

lines(c(1,1)+0.125, 
      d[2,c("LCI", "UCI")], 
      lty = 1, 
      col = "#191970")

lines(c(2,2)-0.125,
      d[3,c("LCI", "UCI")],
      lty = 1,
      col = "#FF8C00")

lines(c(2,2)+0.125,
      d[4,c("LCI", "UCI")],
      lty = 1,
      col = "#191970")


## Figure S2b - Global model predictions

d = newdata2[c(1:4),]
d$Classification = unique(newdata2$Classification)[c(1,1,2,2)]
d$status.s = mean(newdata2$status.s)
d$mass.s = mean(newdata2$mass.s)
d$SCI = unique(newdata2$SCI)[c(1,2,1,2)]  

carpred.coef = modavgPred(cand.set=list(m1),
                          newdata=d, 
                          re.form=~0, 
                          conf.level = 0.95)

d$pred = carpred.coef$mod.avg.pred
d$LCI = carpred.coef$lower.CL
d$UCI = carpred.coef$upper.CL

# Plot Figure S2b

plot(c(1,2)-0.125, 
     d$pred[c(1,2)], 
     xlim=c(0.5,2.5), 
     pch = 16, 
     col = "#FF8C00", 
     ylim=c(0,1600), 
     ylab = "Price per day (USD)",
     xlab = "Difficult or dangerous",
     axes=FALSE)

box(); axis(2); axis(1, at=c(1,2), 
                     labels=c('Yes','No'))

points(c(1,2)+0.125, 
       d$pred[c(3,4)], 
       pch = 16, 
       col = "#191970")

lines(c(1,1)-0.125, 
      d[1,c("LCI", "UCI")], 
      lty = 1, 
      col = "#FF8C00")

lines(c(1,1)+0.125, 
      d[2,c("LCI", "UCI")], 
      lty = 1, 
      col = "#191970")

lines(c(2,2)-0.125, 
      d[3,c("LCI", "UCI")], 
      lty = 1, 
      col = "#FF8C00")

lines(c(2,2)+0.125, 
      d[4,c("LCI", "UCI")], 
      lty = 1, 
      col = "#191970")

legend('topright', 
       legend=c("Carnivore", "Ungulate"),
       pch =c(16,16), 
       col = c("#FF8C00","#191970"),
       bty = "n",
       cex=0.70)


## Figure S3 - in Supplementary Material. (a) Model-averaged and (b) global model predictions for the effect of conservation status on price for carnivore and ungulate species. ##

## Figure S3a - Model-averaged predictions

statuses = seq(-4.5,1,0.1)
min(which(newdata2$Classification=="Ungulate"))
min(which(newdata2$Classification=="Carnivore"))

# For carnivore predictions

dat.car = newdata2[rep(min(which(newdata2$Classification=="Carnivore")),
                       times=length(statuses)),]

dat.car$mass.s = mean(newdata2$mass.s)
dat.car$status.s = statuses
dat.car$SCI = unique(newdata2$SCI)[1] # First run with SCI as [1] 'presence'

pred.car = modavgPred(cand.set=list(m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15), 
                      newdata=dat.car, 
                      second.ord = TRUE,
                      nobs = NULL, 
                      uncond.se = "revised", 
                      conf.level = 0.95)

pred.car1 = pred.car$mod.avg.pred
pred.car1.LCI = pred.car$lower.CL
pred.car1.UCI = pred.car$upper.CL


dat.car$SCI = unique(newdata2$SCI)[2] # Then with SCI as [2] 'absence'

pred.car = modavgPred(cand.set=list(m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15), 
                      newdata=dat.car, 
                      second.ord = TRUE,
                      nobs = NULL, 
                      uncond.se = "revised", 
                      conf.level = 0.95)

pred.car2 = pred.car$mod.avg.pred
pred.car2.LCI = pred.car$lower.CL
pred.car2.UCI = pred.car$upper.CL

# To get carnivore predictions with 'average' SCI

dat.car$pred = (pred.car1 + pred.car2)/2
dat.car$LCI = (pred.car1.LCI + pred.car2.LCI)/2
dat.car$UCI = (pred.car1.UCI + pred.car2.UCI)/2

## for ungulate predictions

dat.un = newdata2[rep(min(which(newdata2$Classification=="Ungulate")),
                      times=length(statuses)),]

dat.un$mass.s = mean(newdata2$mass.s)
dat.un$status.s = statuses
dat.un$SCI = unique(newdata2$SCI)[1] # Run with SCI as [1] 'presence'


pred.un = modavgPred(cand.set=list(m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15), 
                     newdata=dat.un, 
                     second.ord = TRUE,
                     nobs = NULL, 
                     uncond.se = "revised", 
                     conf.level = 0.95)

pred.un1 = pred.un$mod.avg.pred
pred.un1.LCI = pred.un$lower.CL
pred.un1.UCI = pred.un$upper.CL

dat.un$SCI = unique(newdata2$SCI)[2] # Then run with SCI as [2] 'absence'

pred.un = modavgPred(cand.set=list(m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15),
                     newdata=dat.un, second.ord = TRUE,
                     nobs = NULL, uncond.se = "revised", conf.level = 0.95)

pred.un2 = pred.un$mod.avg.pred
pred.un2.LCI = pred.un$lower.CL
pred.un2.UCI = pred.un$upper.CL

# To get ungulate predictions with 'average' SCI

dat.un$pred = (pred.un1 + pred.un2)/2
dat.un$LCI = (pred.un1.LCI + pred.un2.LCI)/2
dat.un$UCI = (pred.un1.UCI + pred.un2.UCI)/2

back.trans2 = function(xa){
  xa*sd(newdata2$Status)+mean(newdata2$Status)
}


# Plot Figure S3a

back.trans2 = function(xa){
  xa*sd(newdata2$Status)+mean(newdata2$Status)
}

plot(back.trans2(as.numeric(newdata2$status.s[newdata2$Classification=='Carnivore'])), 
     newdata2$Day.price[newdata2$Classification=='Carnivore'], 
     col='#FF8C0055',
     pch=17, 
     ylab = "Price per day (USD)",
     xlab = "Status")

points(back.trans2(as.numeric(newdata2$status.s[newdata2$Classification=='Ungulate'])),
       newdata2$Day.price[newdata2$Classification=='Ungulate'], 
       col='#19197055',
       pch=16)

lines(back.trans2(dat.car$status.s),
      dat.car$pred, 
      col='#FF8C0055', 
      lwd = 2)

polygon(c(back.trans2(dat.car$status.s),
          rev(back.trans(dat.car$status.s))),
        c(dat.car$LCI,
          rev(dat.car$UCI)),
        col='#FFDE0055', 
        border=NA)

lines(back.trans2(dat.un$status.s),
      dat.un$pred, 
      col = '#19197055', 
      lwd = 2)

polygon(c(back.trans2(dat.un$status.s),
          rev(back.trans(dat.un$status.s))),
        c(dat.un$LCI,
          rev(dat.un$UCI)),
        col='#19197055', 
        border=NA)


## Figure S3b - Global model predictions 

statuses = seq(-4.5,1,0.1)
min(which(newdata2$Classification=="Ungulate"))
min(which(newdata2$Classification=="Carnivore"))

## Carnivore predictions

dat.car = newdata2[rep(min(which(newdata2$Classification=="Carnivore")),
                       times=length(statuses)),]

dat.car$mass.s = mean(newdata2$mass.s)
dat.car$status.s = statuses
dat.car$SCI = unique(newdata2$SCI)[1] # First run with SCI as [1] 'presence'

pred.car = modavgPred(cand.set=list(m1), 
                      newdata=dat.car, second.ord = TRUE,
                      nobs = NULL, uncond.se = "revised", conf.level = 0.95)

pred.car1 = pred.car$mod.avg.pred
pred.car1.LCI = pred.car$lower.CL
pred.car1.UCI = pred.car$upper.CL


dat.car$SCI = unique(newdata2$SCI)[2] # Then run with SCI as [2] 'absence'

pred.car = modavgPred(cand.set=list(m1), 
                      newdata=dat.car, second.ord = TRUE,
                      nobs = NULL, uncond.se = "revised", conf.level = 0.95)

pred.car2 = pred.car$mod.avg.pred
pred.car2.LCI = pred.car$lower.CL
pred.car2.UCI = pred.car$upper.CL

# To get carnivore predictions with 'average' SCI

dat.car$pred = (pred.car1 + pred.car2)/2
dat.car$LCI = (pred.car1.LCI + pred.car2.LCI)/2
dat.car$UCI = (pred.car1.UCI + pred.car2.UCI)/2

## For ungulate predictions

dat.un = newdata2[rep(min(which(newdata2$Classification=="Ungulate")),times=length(statuses)),]
dat.un$mass.s = mean(newdata2$mass.s)
dat.un$status.s = statuses
dat.un$SCI = unique(newdata2$SCI)[1] # Run with SCI as [1] 'presence'

pred.un = modavgPred(cand.set=list(m1), 
                     newdata=dat.un, 
                     second.ord = TRUE,
                     nobs = NULL, 
                     uncond.se = "revised", 
                     conf.level = 0.95)

pred.un1 = pred.un$mod.avg.pred
pred.un1.LCI = pred.un$lower.CL
pred.un1.UCI = pred.un$upper.CL


dat.un$SCI = unique(newdata2$SCI)[2] # Then run with SCI as [2] 'absence'

pred.un = modavgPred(cand.set=list(m1),
                     newdata=dat.un, 
                     second.ord = TRUE,
                     nobs = NULL, 
                     uncond.se = "revised", 
                     conf.level = 0.95)

pred.un2 = pred.un$mod.avg.pred
pred.un2.LCI = pred.un$lower.CL
pred.un2.UCI = pred.un$upper.CL

# To get ungulate predictions with 'average' SCI

dat.un$pred = (pred.un1 + pred.un2)/2
dat.un$LCI = (pred.un1.LCI + pred.un2.LCI)/2
dat.un$UCI = (pred.un1.UCI + pred.un2.UCI)/2


# Plot Figure S3b

back.trans2 = function(xa){
  xa*sd(newdata2$Status)+mean(newdata2$Status)
}

plot(back.trans2(as.numeric(newdata2$status.s[newdata2$Classification=='Carnivore'])), 
     newdata2$Day.price[newdata2$Classification=='Carnivore'], 
     col='#FF8C0055',
     pch=17, 
     ylab = "Price per day (USD)",
     xlab = "Status")

points(back.trans2(as.numeric(newdata2$status.s[newdata2$Classification=='Ungulate'])),
       newdata2$Day.price[newdata2$Classification=='Ungulate'], 
       col='#19197055',
       pch=16)

lines(back.trans2(dat.car$status.s),
      dat.car$pred, 
      col='#FF8C0055', 
      lwd = 2)

polygon(c(back.trans2(dat.car$status.s),
          rev(back.trans(dat.car$status.s))),
        c(dat.car$LCI,
          rev(dat.car$UCI)),
        col='#FFDE0055', 
        border=NA)

lines(back.trans2(dat.un$status.s),
      dat.un$pred, 
      col = '#19197055', 
      lwd = 2)

polygon(c(back.trans2(dat.un$status.s),
          rev(back.trans(dat.un$status.s))),
        c(dat.un$LCI,
          rev(dat.un$UCI)),
        col='#19197055', 
        border=NA)

legend('topright', 
       legend=c("Carnivore", "Ungulate"),
       col=c("#FF8C00", "#191970"), 
       pch = c(17,16), 
       bty ="n",
       cex=0.70)



## Figure S4 - in Supplementary Material. Predictions for relationship between latitude and mass for carnivore and ungulate species. ##

m5lat <- lm(Latitude ~ Avg.Mass*Classification, data = newdata2)
masses = seq(20,440,1)

# For carnivore predictions 

dat.carlat = newdata2[rep(min(which(newdata2$Classification=="Carnivore")),
                          times=length(masses)),]

dat.carlat$Avg.Mass = masses


pred.carlat = modavgPred(cand.set=list(m5lat), 
                         newdata=dat.carlat, 
                         second.ord = TRUE,
                         nobs = NULL, 
                         uncond.se = "revised", 
                         conf.level = 0.95)

dat.carlat$pred = pred.carlat$mod.avg.pred
dat.carlat$LCI = pred.carlat$lower.CL
dat.carlat$UCI = pred.carlat$upper.CL


# For ungulate predictions

dat.unlat = newdata2[rep(min(which(newdata2$Classification=="Ungulate")),
                         times=length(masses)),]

dat.unlat$Avg.Mass = masses
pred.unlat = modavgPred(cand.set=list(m5lat), 
                        newdata=dat.unlat, 
                        second.ord = TRUE,
                        nobs = NULL, 
                        uncond.se = "revised", 
                        conf.level = 0.95)

dat.unlat$pred = pred.unlat$mod.avg.pred
dat.unlat$LCI = pred.unlat$lower.CL
dat.unlat$UCI = pred.unlat$upper.CL

# Plot Figure S4
par(mfrow=c(1,1))

plot(as.numeric(newdata2$Avg.Mass[newdata2$Classification=='Carnivore']),
     newdata2$Latitude[newdata2$Classification=='Carnivore'], 
     col='#FF8C0055',
     pch=17, 
     xlab = "Average Mass (kg)", 
     ylab = "Latitude (Decimal Degrees)",
     xlim=c(40, 415), 
     ylim=c(27, 72))

points(as.numeric(newdata2$Avg.Mass[newdata2$Classification=='Ungulate']),
       newdata2$Latitude[newdata2$Classification=='Ungulate'], 
       col='#19197055',
       pch=16)

lines(dat.carlat$Avg.Mass, 
      dat.carlat$pred, 
      col='#FF8C00', 
      lwd = 1.5)

polygon(c(dat.carlat$Avg.Mass,
          rev(dat.carlat$Avg.Mass)),
        c(dat.carlat$LCI,
          rev(dat.carlat$UCI)),
        col='#FFDE0055', 
        border=NA)

lines(dat.unlat$Avg.Mass,
      dat.unlat$pred, 
      col='#191970', 
      lwd = 1.5)

polygon(c(dat.unlat$Avg.Mass,
          rev(dat.unlat$Avg.Mass)),
        c(dat.unlat$LCI,
          rev(dat.unlat$UCI)),
        col='#19197055', 
        border=NA)

legend(x = c(240, 300),
       y = c(73, 65), 
       legend=c("Carnivore", "Ungulate"),
       col=c("#FF8C00", "#191970"), 
       pch = c(17,16),
       bty = "n",
       cex=0.70)


## Figure S5 - in Supplementary Material. Top model with latitude replacing mass. ##

# Run model with latitude replacing mass as predictor
m5lat <- glmer(Day.price ~ 
                 Classification
               + lat.s         
               + Classification*lat.s
               + (1|Species) + (1|Province.State), 
               data = newdata2, 
               family = Gamma(link='log'))

lats = seq(-2.5,2.5,0.1)

# Predictions for carnivores 

dat.car = newdata2[rep(min(which(newdata2$Classification=="Carnivore")),
                       times=length(lats)),]

dat.car$lat.s = lats
dat.car$status.s = mean(newdata2$status.s)
dat.car$SCI = unique(newdata2$SCI)[1]

pred.car = modavgPred(cand.set=list(m5lat), 
                      newdata=dat.car, 
                      second.ord = TRUE,
                      nobs = NULL, 
                      uncond.se = "revised", 
                      conf.level = 0.95)

dat.car$pred = pred.car$mod.avg.pred
dat.car$LCI = pred.car$lower.CL
dat.car$UCI = pred.car$upper.CL

# Predictions for ungulates

dat.un = newdata2[rep(min(which(newdata2$Classification=="Ungulate")),
                      times=length(lats)),]

dat.un$lat.s = lats
dat.un$status.s = mean(newdata2$status.s)
dat.un$SCI = unique(newdata2$SCI)[1]

pred.un = modavgPred(cand.set=list(m5lat),
                     newdata=dat.un, 
                     second.ord = TRUE,
                     nobs = NULL, 
                     uncond.se = "revised", 
                     conf.level = 0.95)

dat.un$pred = pred.un$mod.avg.pred
dat.un$LCI = pred.un$lower.CL
dat.un$UCI = pred.un$upper.CL


# Plot Figure S5

back.trans = function(x){
  x*sd(newdata2$Latitude)+mean(newdata2$Latitude)
}

plot(as.numeric(back.trans(newdata2$lat.s[newdata2$Classification=='Carnivore'])),
     newdata2$Day.price[newdata2$Classification=='Carnivore'], 
     col='#FF8C0055',
     pch=17, 
     xlab = "Latitude (Decimal Degrees)", 
     ylab = "Price per day (USD)", 
     xlim=c(28.06, 70))

points(as.numeric(back.trans(newdata2$lat.s[newdata2$Classification=='Ungulate'])),
       newdata2$Day.price[newdata2$Classification=='Ungulate'], 
       col='#19197055',
       pch=16)

lines(back.trans(dat.car$lat.s),
      dat.car$pred, 
      col='#FF8C00', 
      lwd = 1.5)

polygon(c(back.trans(dat.car$lat.s),
          rev(back.trans(dat.car$lat.s))),
        c(dat.car$LCI,
          rev(dat.car$UCI)),
        col='#FFDE0055', 
        border=NA)

lines(back.trans(dat.un$lat.s),
      dat.un$pred, 
      col='#191970', 
      lwd = 1.5)

polygon(c(back.trans(dat.un$lat.s),
          rev(back.trans(dat.un$lat.s))),
        c(dat.un$LCI,rev(dat.un$UCI)),
        col='#19197055', 
        border=NA)

legend(x = c(35, 43),y = c(4750, 4000), 
       legend=c("Carnivore", "Ungulate"),
       col=c("#FF8C00", "#191970"), 
       pch = c(17,16), 
       bty = "n",
       cex=0.70)


